
:setvar DatabaseName "Registry"
:setvar MajorReleaseNumber "1"
:setvar MinorReleaseNumber "0"
:setvar PointReleaseNumber "50"
:setvar DeployVersion "20150820.1"
:setvar LogicalFileName "AHOBPR_Data"
:setvar PhysicalFileName "AHOBPR_Data.ndf"
:setvar DefaultLogPath "L:\SQLLogs\"
 -- VA SQL 20
:setvar DefaultDataPath "S:\SQLData\"
-- VA SQL 70 values
--:setvar DefaultDataPath "M:\SQLData\UserDB\Registry_AHOBPR\"

GO

PRINT 'Step 1 - Registry.Database.PreDeploy.sql
Version Release $(MajorReleaseNumber).$(MinorReleaseNumber).$(PointReleaseNumber)
BUILD $(DeployVersion)
 ';
PRINT 'Started ' + CAST(GETDATE() as varchar(20)) + '.
*********************************************************
NOTE: This script must be run with SQLCMD Mode turned on.
*********************************************************

 ';
GO

:on error exit
GO
:setvar __IsSqlCmdEnabled "True"
/*
Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
To re-enable the script after enabling SQLCMD mode, execute the following:
SET NOEXEC OFF; 
*/
GO
IF N'$(__IsSqlCmdEnabled)' NOT LIKE N'True'
    BEGIN
        PRINT N'SQLCMD mode must be enabled to successfully execute this script.';
        SET NOEXEC ON;
    END

GO

PRINT N'Creating FILEGROUP [AHOBPR]...';


GO
IF NOT EXISTS(SELECT * FROM sys.filegroups WHERE [NAME] = 'AHOBPR')
  ALTER DATABASE [$(DatabaseName)]
      ADD FILEGROUP [AHOBPR];


GO

PRINT N'$(LogicalFileName)';
PRINT N'$(DefaultDataPath)$(PhysicalFileName)';

IF NOT EXISTS(SELECT * FROM sys.database_files WHERE [NAME] =N'$(LogicalFileName)')
  ALTER DATABASE [$(DatabaseName)]
      ADD FILE (NAME = [N$(LogicalFileName)], FILENAME = N'$(DefaultDataPath)$(PhysicalFileName)',
      SIZE = 6000MB , MAXSIZE = UNLIMITED, FILEGROWTH = 200MB) TO FILEGROUP [AHOBPR];
GO

IF NOT EXISTS(SELECT * FROM sys.filegroups WHERE [NAME] = 'FILESTREAMGroup')
  ALTER DATABASE [$(DatabaseName)]
      ADD FILEGROUP [FILESTREAMGroup] CONTAINS FILESTREAM;
GO
    
IF NOT EXISTS(SELECT * FROM sys.database_files WHERE [NAME] = 'AHOBPR_FILESTREAM')
  ALTER DATABASE [$(DatabaseName)]
      ADD FILE (NAME = [AHOBPR_FILESTREAM], FILENAME = N'$(DefaultDataPath)AHOBPR_FILESTREAM') 
      TO FILEGROUP [FILESTREAMGroup];
       

GO


INSERT INTO [dbo].[DatabaseChangeLog]
           ([MajorReleaseNumber]
           ,[MinorReleaseNumber]
           ,[PointReleaseNumber]
           ,[Hotfix]
           ,[ScriptName]
           ,[ScriptDescription]
           ,[TargetRegistry]
           ,[DateApplied])
     VALUES
           ('$(MajorReleaseNumber)'
           ,'$(MinorReleaseNumber)'
           ,'$(PointReleaseNumber)'
           ,0
           ,'Step 1 - Registry.Database.PreDeploy.sql'
		       ,'Create FileGroups And File AHOBPR'
           ,'AHOBPR'
           ,GETDATE());


PRINT '';
PRINT 'Step 1 - Registry.Database.PreDeploy.sql Script Complete.';
PRINT '';
PRINT 'Completed ' + CAST(GETDATE() AS varchar(20)) + '.';
-----------------------
-- END OF PRE-DEPLOY --
-----------------------